IF EXISTS (
    SELECT * 
    FROM sys.columns 
    WHERE name = 'CD_CTB_CNT' 
      AND object_id = OBJECT_ID('RC_CLI_CONV')
)
BEGIN
    DECLARE @ConstraintName NVARCHAR(200);
    DECLARE @SQL NVARCHAR(MAX);

    -- Busca a constraint DEFAULT da coluna
    SELECT @ConstraintName = dc.name
    FROM sys.default_constraints dc
    INNER JOIN sys.columns c 
        ON dc.parent_object_id = c.object_id 
       AND dc.parent_column_id = c.column_id
    WHERE dc.parent_object_id = OBJECT_ID('RC_CLI_CONV')
      AND c.name = 'CD_CTB_CNT';

    -- Se existir, dropa
    IF @ConstraintName IS NOT NULL
    BEGIN
        SET @SQL = N'ALTER TABLE RC_CLI_CONV DROP CONSTRAINT ' + QUOTENAME(@ConstraintName) + ';';
        EXEC sp_executesql @SQL;
    END

    -- Agora altera a coluna
    ALTER TABLE RC_CLI_CONV
    ALTER COLUMN CD_CTB_CNT VARCHAR(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL;
END
